/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;

public class GMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2777097312029690941L;
    private static final boolean debug = false;
    int nRow;
    int nCol;
    double[][] values;
    private static final double EPS = 1.0E-10;

    public GMatrix(int n2, int n3) {
        int n4;
        this.values = new double[n2][n3];
        this.nRow = n2;
        this.nCol = n3;
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.values[n4][i2] = 0.0;
            }
        }
        int n5 = n2 < n3 ? n2 : n3;
        for (n4 = 0; n4 < n5; ++n4) {
            this.values[n4][n4] = 1.0;
        }
    }

    public GMatrix(int n2, int n3, double[] dArray) {
        this.values = new double[n2][n3];
        this.nRow = n2;
        this.nCol = n3;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.values[i2][i3] = dArray[i2 * n3 + i3];
            }
        }
    }

    public GMatrix(GMatrix gMatrix) {
        this.nRow = gMatrix.nRow;
        this.nCol = gMatrix.nCol;
        this.values = new double[this.nRow][this.nCol];
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = gMatrix.values[i2][i3];
            }
        }
    }

    public final void mul(GMatrix gMatrix) {
        if (this.nCol != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix0"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                dArray[i2][i3] = 0.0;
                for (int i4 = 0; i4 < this.nCol; ++i4) {
                    double[] dArray2 = dArray[i2];
                    int n2 = i3;
                    dArray2[n2] = dArray2[n2] + this.values[i2][i4] * gMatrix.values[i4][i3];
                }
            }
        }
        this.values = dArray;
    }

    public final void mul(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nRow || this.nRow != gMatrix.nRow || this.nCol != gMatrix2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix1"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        for (int i2 = 0; i2 < gMatrix.nRow; ++i2) {
            for (int i3 = 0; i3 < gMatrix2.nCol; ++i3) {
                dArray[i2][i3] = 0.0;
                for (int i4 = 0; i4 < gMatrix.nCol; ++i4) {
                    double[] dArray2 = dArray[i2];
                    int n2 = i3;
                    dArray2[n2] = dArray2[n2] + gMatrix.values[i2][i4] * gMatrix2.values[i4][i3];
                }
            }
        }
        this.values = dArray;
    }

    public final void mul(GVector gVector, GVector gVector2) {
        if (this.nRow < gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix2"));
        }
        if (this.nCol < gVector2.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix3"));
        }
        for (int i2 = 0; i2 < gVector.getSize(); ++i2) {
            for (int i3 = 0; i3 < gVector2.getSize(); ++i3) {
                this.values[i2][i3] = gVector.values[i2] * gVector2.values[i3];
            }
        }
    }

    public final void add(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix4"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix5"));
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = this.values[i2][i3] + gMatrix.values[i2][i3];
            }
        }
    }

    public final void add(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix2.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix6"));
        }
        if (gMatrix2.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix7"));
        }
        if (this.nCol != gMatrix.nCol || this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix8"));
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = gMatrix.values[i2][i3] + gMatrix2.values[i2][i3];
            }
        }
    }

    public final void sub(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix9"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix28"));
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = this.values[i2][i3] - gMatrix.values[i2][i3];
            }
        }
    }

    public final void sub(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix2.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix10"));
        }
        if (gMatrix2.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix11"));
        }
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix12"));
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = gMatrix.values[i2][i3] - gMatrix2.values[i2][i3];
            }
        }
    }

    public final void negate() {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = -this.values[i2][i3];
            }
        }
    }

    public final void negate(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix13"));
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = -gMatrix.values[i2][i3];
            }
        }
    }

    public final void setIdentity() {
        int n2;
        for (n2 = 0; n2 < this.nRow; ++n2) {
            for (int i2 = 0; i2 < this.nCol; ++i2) {
                this.values[n2][i2] = 0.0;
            }
        }
        int n3 = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (n2 = 0; n2 < n3; ++n2) {
            this.values[n2][n2] = 1.0;
        }
    }

    public final void setZero() {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = 0.0;
            }
        }
    }

    public final void identityMinus() {
        int n2;
        for (n2 = 0; n2 < this.nRow; ++n2) {
            for (int i2 = 0; i2 < this.nCol; ++i2) {
                this.values[n2][i2] = -this.values[n2][i2];
            }
        }
        int n3 = this.nRow < this.nCol ? this.nRow : this.nCol;
        n2 = 0;
        while (n2 < n3) {
            double[] dArray = this.values[n2];
            int n4 = n2++;
            dArray[n4] = dArray[n4] + 1.0;
        }
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void invert(GMatrix gMatrix) {
        this.invertGeneral(gMatrix);
    }

    public final void copySubMatrix(int n2, int n3, int n4, int n5, int n6, int n7, GMatrix gMatrix) {
        if (this != gMatrix) {
            for (int i2 = 0; i2 < n4; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    gMatrix.values[n6 + i2][n7 + i3] = this.values[n2 + i2][n3 + i3];
                }
            }
        } else {
            int n8;
            int n9;
            double[][] dArray = new double[n4][n5];
            for (n9 = 0; n9 < n4; ++n9) {
                for (n8 = 0; n8 < n5; ++n8) {
                    dArray[n9][n8] = this.values[n2 + n9][n3 + n8];
                }
            }
            for (n9 = 0; n9 < n4; ++n9) {
                for (n8 = 0; n8 < n5; ++n8) {
                    gMatrix.values[n6 + n9][n7 + n8] = dArray[n9][n8];
                }
            }
        }
    }

    public final void setSize(int n2, int n3) {
        double[][] dArray = new double[n2][n3];
        int n4 = this.nRow < n2 ? this.nRow : n2;
        int n5 = this.nCol < n3 ? this.nCol : n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n5; ++i3) {
                dArray[i2][i3] = this.values[i2][i3];
            }
        }
        this.nRow = n2;
        this.nCol = n3;
        this.values = dArray;
    }

    public final void set(double[] dArray) {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = dArray[this.nCol * i2 + i3];
            }
        }
    }

    public final void set(Matrix3f matrix3f) {
        if (this.nCol < 3 || this.nRow < 3) {
            this.nCol = 3;
            this.nRow = 3;
            this.values = new double[this.nRow][this.nCol];
        }
        this.values[0][0] = matrix3f.m00;
        this.values[0][1] = matrix3f.m01;
        this.values[0][2] = matrix3f.m02;
        this.values[1][0] = matrix3f.m10;
        this.values[1][1] = matrix3f.m11;
        this.values[1][2] = matrix3f.m12;
        this.values[2][0] = matrix3f.m20;
        this.values[2][1] = matrix3f.m21;
        this.values[2][2] = matrix3f.m22;
        for (int i2 = 3; i2 < this.nRow; ++i2) {
            for (int i3 = 3; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = 0.0;
            }
        }
    }

    public final void set(Matrix3d matrix3d) {
        if (this.nRow < 3 || this.nCol < 3) {
            this.values = new double[3][3];
            this.nRow = 3;
            this.nCol = 3;
        }
        this.values[0][0] = matrix3d.m00;
        this.values[0][1] = matrix3d.m01;
        this.values[0][2] = matrix3d.m02;
        this.values[1][0] = matrix3d.m10;
        this.values[1][1] = matrix3d.m11;
        this.values[1][2] = matrix3d.m12;
        this.values[2][0] = matrix3d.m20;
        this.values[2][1] = matrix3d.m21;
        this.values[2][2] = matrix3d.m22;
        for (int i2 = 3; i2 < this.nRow; ++i2) {
            for (int i3 = 3; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = 0.0;
            }
        }
    }

    public final void set(Matrix4f matrix4f) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = matrix4f.m00;
        this.values[0][1] = matrix4f.m01;
        this.values[0][2] = matrix4f.m02;
        this.values[0][3] = matrix4f.m03;
        this.values[1][0] = matrix4f.m10;
        this.values[1][1] = matrix4f.m11;
        this.values[1][2] = matrix4f.m12;
        this.values[1][3] = matrix4f.m13;
        this.values[2][0] = matrix4f.m20;
        this.values[2][1] = matrix4f.m21;
        this.values[2][2] = matrix4f.m22;
        this.values[2][3] = matrix4f.m23;
        this.values[3][0] = matrix4f.m30;
        this.values[3][1] = matrix4f.m31;
        this.values[3][2] = matrix4f.m32;
        this.values[3][3] = matrix4f.m33;
        for (int i2 = 4; i2 < this.nRow; ++i2) {
            for (int i3 = 4; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = 0.0;
            }
        }
    }

    public final void set(Matrix4d matrix4d) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = matrix4d.m00;
        this.values[0][1] = matrix4d.m01;
        this.values[0][2] = matrix4d.m02;
        this.values[0][3] = matrix4d.m03;
        this.values[1][0] = matrix4d.m10;
        this.values[1][1] = matrix4d.m11;
        this.values[1][2] = matrix4d.m12;
        this.values[1][3] = matrix4d.m13;
        this.values[2][0] = matrix4d.m20;
        this.values[2][1] = matrix4d.m21;
        this.values[2][2] = matrix4d.m22;
        this.values[2][3] = matrix4d.m23;
        this.values[3][0] = matrix4d.m30;
        this.values[3][1] = matrix4d.m31;
        this.values[3][2] = matrix4d.m32;
        this.values[3][3] = matrix4d.m33;
        for (int i2 = 4; i2 < this.nRow; ++i2) {
            for (int i3 = 4; i3 < this.nCol; ++i3) {
                this.values[i2][i3] = 0.0;
            }
        }
    }

    public final void set(GMatrix gMatrix) {
        int n2;
        int n3;
        if (this.nRow < gMatrix.nRow || this.nCol < gMatrix.nCol) {
            this.nRow = gMatrix.nRow;
            this.nCol = gMatrix.nCol;
            this.values = new double[this.nRow][this.nCol];
        }
        for (n3 = 0; n3 < Math.min(this.nRow, gMatrix.nRow); ++n3) {
            for (n2 = 0; n2 < Math.min(this.nCol, gMatrix.nCol); ++n2) {
                this.values[n3][n2] = gMatrix.values[n3][n2];
            }
        }
        for (n3 = gMatrix.nRow; n3 < this.nRow; ++n3) {
            for (n2 = gMatrix.nCol; n2 < this.nCol; ++n2) {
                this.values[n3][n2] = 0.0;
            }
        }
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int n2, int n3) {
        return this.values[n2][n3];
    }

    public final void setElement(int n2, int n3, double d2) {
        this.values[n2][n3] = d2;
    }

    public final void getRow(int n2, double[] dArray) {
        for (int i2 = 0; i2 < this.nCol; ++i2) {
            dArray[i2] = this.values[n2][i2];
        }
    }

    public final void getRow(int n2, GVector gVector) {
        if (gVector.getSize() < this.nCol) {
            gVector.setSize(this.nCol);
        }
        for (int i2 = 0; i2 < this.nCol; ++i2) {
            gVector.values[i2] = this.values[n2][i2];
        }
    }

    public final void getColumn(int n2, double[] dArray) {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            dArray[i2] = this.values[i2][n2];
        }
    }

    public final void getColumn(int n2, GVector gVector) {
        if (gVector.getSize() < this.nRow) {
            gVector.setSize(this.nRow);
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            gVector.values[i2] = this.values[i2][n2];
        }
    }

    public final void get(Matrix3d matrix3d) {
        if (this.nRow < 3 || this.nCol < 3) {
            matrix3d.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix3d.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        matrix3d.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            matrix3d.m20 = this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix3d.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            matrix3d.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                matrix3d.m21 = this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        matrix3d.m02 = this.values[0][2];
                        if (this.nRow > 1) {
                            matrix3d.m12 = this.values[1][2];
                            if (this.nRow > 2) {
                                matrix3d.m22 = this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            matrix3d.m00 = this.values[0][0];
            matrix3d.m01 = this.values[0][1];
            matrix3d.m02 = this.values[0][2];
            matrix3d.m10 = this.values[1][0];
            matrix3d.m11 = this.values[1][1];
            matrix3d.m12 = this.values[1][2];
            matrix3d.m20 = this.values[2][0];
            matrix3d.m21 = this.values[2][1];
            matrix3d.m22 = this.values[2][2];
        }
    }

    public final void get(Matrix3f matrix3f) {
        if (this.nRow < 3 || this.nCol < 3) {
            matrix3f.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix3f.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        matrix3f.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            matrix3f.m20 = (float)this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix3f.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            matrix3f.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                matrix3f.m21 = (float)this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        matrix3f.m02 = (float)this.values[0][2];
                        if (this.nRow > 1) {
                            matrix3f.m12 = (float)this.values[1][2];
                            if (this.nRow > 2) {
                                matrix3f.m22 = (float)this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            matrix3f.m00 = (float)this.values[0][0];
            matrix3f.m01 = (float)this.values[0][1];
            matrix3f.m02 = (float)this.values[0][2];
            matrix3f.m10 = (float)this.values[1][0];
            matrix3f.m11 = (float)this.values[1][1];
            matrix3f.m12 = (float)this.values[1][2];
            matrix3f.m20 = (float)this.values[2][0];
            matrix3f.m21 = (float)this.values[2][1];
            matrix3f.m22 = (float)this.values[2][2];
        }
    }

    public final void get(Matrix4d matrix4d) {
        if (this.nRow < 4 || this.nCol < 4) {
            matrix4d.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix4d.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        matrix4d.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            matrix4d.m20 = this.values[2][0];
                            if (this.nRow > 3) {
                                matrix4d.m30 = this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix4d.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            matrix4d.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                matrix4d.m21 = this.values[2][1];
                                if (this.nRow > 3) {
                                    matrix4d.m31 = this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            matrix4d.m02 = this.values[0][2];
                            if (this.nRow > 1) {
                                matrix4d.m12 = this.values[1][2];
                                if (this.nRow > 2) {
                                    matrix4d.m22 = this.values[2][2];
                                    if (this.nRow > 3) {
                                        matrix4d.m32 = this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            matrix4d.m03 = this.values[0][3];
                            if (this.nRow > 1) {
                                matrix4d.m13 = this.values[1][3];
                                if (this.nRow > 2) {
                                    matrix4d.m23 = this.values[2][3];
                                    if (this.nRow > 3) {
                                        matrix4d.m33 = this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            matrix4d.m00 = this.values[0][0];
            matrix4d.m01 = this.values[0][1];
            matrix4d.m02 = this.values[0][2];
            matrix4d.m03 = this.values[0][3];
            matrix4d.m10 = this.values[1][0];
            matrix4d.m11 = this.values[1][1];
            matrix4d.m12 = this.values[1][2];
            matrix4d.m13 = this.values[1][3];
            matrix4d.m20 = this.values[2][0];
            matrix4d.m21 = this.values[2][1];
            matrix4d.m22 = this.values[2][2];
            matrix4d.m23 = this.values[2][3];
            matrix4d.m30 = this.values[3][0];
            matrix4d.m31 = this.values[3][1];
            matrix4d.m32 = this.values[3][2];
            matrix4d.m33 = this.values[3][3];
        }
    }

    public final void get(Matrix4f matrix4f) {
        if (this.nRow < 4 || this.nCol < 4) {
            matrix4f.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    matrix4f.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        matrix4f.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            matrix4f.m20 = (float)this.values[2][0];
                            if (this.nRow > 3) {
                                matrix4f.m30 = (float)this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        matrix4f.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            matrix4f.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                matrix4f.m21 = (float)this.values[2][1];
                                if (this.nRow > 3) {
                                    matrix4f.m31 = (float)this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            matrix4f.m02 = (float)this.values[0][2];
                            if (this.nRow > 1) {
                                matrix4f.m12 = (float)this.values[1][2];
                                if (this.nRow > 2) {
                                    matrix4f.m22 = (float)this.values[2][2];
                                    if (this.nRow > 3) {
                                        matrix4f.m32 = (float)this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            matrix4f.m03 = (float)this.values[0][3];
                            if (this.nRow > 1) {
                                matrix4f.m13 = (float)this.values[1][3];
                                if (this.nRow > 2) {
                                    matrix4f.m23 = (float)this.values[2][3];
                                    if (this.nRow > 3) {
                                        matrix4f.m33 = (float)this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            matrix4f.m00 = (float)this.values[0][0];
            matrix4f.m01 = (float)this.values[0][1];
            matrix4f.m02 = (float)this.values[0][2];
            matrix4f.m03 = (float)this.values[0][3];
            matrix4f.m10 = (float)this.values[1][0];
            matrix4f.m11 = (float)this.values[1][1];
            matrix4f.m12 = (float)this.values[1][2];
            matrix4f.m13 = (float)this.values[1][3];
            matrix4f.m20 = (float)this.values[2][0];
            matrix4f.m21 = (float)this.values[2][1];
            matrix4f.m22 = (float)this.values[2][2];
            matrix4f.m23 = (float)this.values[2][3];
            matrix4f.m30 = (float)this.values[3][0];
            matrix4f.m31 = (float)this.values[3][1];
            matrix4f.m32 = (float)this.values[3][2];
            matrix4f.m33 = (float)this.values[3][3];
        }
    }

    public final void get(GMatrix gMatrix) {
        int n2;
        int n3;
        int n4 = this.nCol < gMatrix.nCol ? this.nCol : gMatrix.nCol;
        int n5 = this.nRow < gMatrix.nRow ? this.nRow : gMatrix.nRow;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                gMatrix.values[n3][n2] = this.values[n3][n2];
            }
        }
        for (n3 = n5; n3 < gMatrix.nRow; ++n3) {
            for (n2 = 0; n2 < gMatrix.nCol; ++n2) {
                gMatrix.values[n3][n2] = 0.0;
            }
        }
        for (n2 = n4; n2 < gMatrix.nCol; ++n2) {
            for (n3 = 0; n3 < n5; ++n3) {
                gMatrix.values[n3][n2] = 0.0;
            }
        }
    }

    public final void setRow(int n2, double[] dArray) {
        for (int i2 = 0; i2 < this.nCol; ++i2) {
            this.values[n2][i2] = dArray[i2];
        }
    }

    public final void setRow(int n2, GVector gVector) {
        for (int i2 = 0; i2 < this.nCol; ++i2) {
            this.values[n2][i2] = gVector.values[i2];
        }
    }

    public final void setColumn(int n2, double[] dArray) {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            this.values[i2][n2] = dArray[i2];
        }
    }

    public final void setColumn(int n2, GVector gVector) {
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            this.values[i2][n2] = gVector.values[i2];
        }
    }

    public final void mulTransposeBoth(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nRow != gMatrix2.nCol || this.nRow != gMatrix.nCol || this.nCol != gMatrix2.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix14"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    dArray[i2][i3] = 0.0;
                    for (int i4 = 0; i4 < gMatrix.nRow; ++i4) {
                        double[] dArray2 = dArray[i2];
                        int n2 = i3;
                        dArray2[n2] = dArray2[n2] + gMatrix.values[i4][i2] * gMatrix2.values[i3][i4];
                    }
                }
            }
            this.values = dArray;
        } else {
            for (int i5 = 0; i5 < this.nRow; ++i5) {
                for (int i6 = 0; i6 < this.nCol; ++i6) {
                    this.values[i5][i6] = 0.0;
                    for (int i7 = 0; i7 < gMatrix.nRow; ++i7) {
                        double[] dArray = this.values[i5];
                        int n3 = i6;
                        dArray[n3] = dArray[n3] + gMatrix.values[i7][i5] * gMatrix2.values[i6][i7];
                    }
                }
            }
        }
    }

    public final void mulTransposeRight(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nCol || this.nCol != gMatrix2.nRow || this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix15"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    dArray[i2][i3] = 0.0;
                    for (int i4 = 0; i4 < gMatrix.nCol; ++i4) {
                        double[] dArray2 = dArray[i2];
                        int n2 = i3;
                        dArray2[n2] = dArray2[n2] + gMatrix.values[i2][i4] * gMatrix2.values[i3][i4];
                    }
                }
            }
            this.values = dArray;
        } else {
            for (int i5 = 0; i5 < this.nRow; ++i5) {
                for (int i6 = 0; i6 < this.nCol; ++i6) {
                    this.values[i5][i6] = 0.0;
                    for (int i7 = 0; i7 < gMatrix.nCol; ++i7) {
                        double[] dArray = this.values[i5];
                        int n3 = i6;
                        dArray[n3] = dArray[n3] + gMatrix.values[i5][i7] * gMatrix2.values[i6][i7];
                    }
                }
            }
        }
    }

    public final void mulTransposeLeft(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol || this.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix16"));
        }
        if (gMatrix == this || gMatrix2 == this) {
            double[][] dArray = new double[this.nRow][this.nCol];
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    dArray[i2][i3] = 0.0;
                    for (int i4 = 0; i4 < gMatrix.nRow; ++i4) {
                        double[] dArray2 = dArray[i2];
                        int n2 = i3;
                        dArray2[n2] = dArray2[n2] + gMatrix.values[i4][i2] * gMatrix2.values[i4][i3];
                    }
                }
            }
            this.values = dArray;
        } else {
            for (int i5 = 0; i5 < this.nRow; ++i5) {
                for (int i6 = 0; i6 < this.nCol; ++i6) {
                    this.values[i5][i6] = 0.0;
                    for (int i7 = 0; i7 < gMatrix.nRow; ++i7) {
                        double[] dArray = this.values[i5];
                        int n3 = i6;
                        dArray[n3] = dArray[n3] + gMatrix.values[i7][i5] * gMatrix2.values[i7][i6];
                    }
                }
            }
        }
    }

    public final void transpose() {
        if (this.nRow != this.nCol) {
            int n2 = this.nRow;
            this.nRow = this.nCol;
            this.nCol = n2;
            double[][] dArray = new double[this.nRow][this.nCol];
            for (n2 = 0; n2 < this.nRow; ++n2) {
                for (int i2 = 0; i2 < this.nCol; ++i2) {
                    dArray[n2][i2] = this.values[i2][n2];
                }
            }
            this.values = dArray;
        } else {
            for (int i3 = 0; i3 < this.nRow; ++i3) {
                for (int i4 = 0; i4 < i3; ++i4) {
                    double d2 = this.values[i3][i4];
                    this.values[i3][i4] = this.values[i4][i3];
                    this.values[i4][i3] = d2;
                }
            }
        }
    }

    public final void transpose(GMatrix gMatrix) {
        if (this.nRow != gMatrix.nCol || this.nCol != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix17"));
        }
        if (gMatrix != this) {
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    this.values[i2][i3] = gMatrix.values[i3][i2];
                }
            }
        } else {
            this.transpose();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nRow * this.nCol * 8);
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                stringBuffer.append(this.values[i2][i3]).append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static void checkMatrix(GMatrix gMatrix) {
        for (int i2 = 0; i2 < gMatrix.nRow; ++i2) {
            for (int i3 = 0; i3 < gMatrix.nCol; ++i3) {
                if (Math.abs(gMatrix.values[i2][i3]) < 1.0E-10) {
                    System.out.print(" 0.0     ");
                    continue;
                }
                System.out.print(" " + gMatrix.values[i2][i3]);
            }
            System.out.print("\n");
        }
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + (long)this.nRow;
        l2 = 31L * l2 + (long)this.nCol;
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.values[i2][i3]);
            }
        }
        return (int)(l2 ^ l2 >> 32);
    }

    public boolean equals(GMatrix gMatrix) {
        try {
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    if (this.values[i2][i3] == gMatrix.values[i2][i3]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            GMatrix gMatrix = (GMatrix)object;
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            for (int i2 = 0; i2 < this.nRow; ++i2) {
                for (int i3 = 0; i3 < this.nCol; ++i3) {
                    if (this.values[i2][i3] == gMatrix.values[i2][i3]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(GMatrix gMatrix, float f2) {
        return this.epsilonEquals(gMatrix, (double)f2);
    }

    public boolean epsilonEquals(GMatrix gMatrix, double d2) {
        if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            return false;
        }
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                double d3 = this.values[i2][i3] - gMatrix.values[i2][i3];
                double d4 = d3 < 0.0 ? -d3 : d3;
                if (!(d4 > d2)) continue;
                return false;
            }
        }
        return true;
    }

    public final double trace() {
        int n2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.values[i2][i2];
        }
        return d2;
    }

    public final int SVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3) {
        if (this.nCol != gMatrix3.nCol || this.nCol != gMatrix3.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix18"));
        }
        if (this.nRow != gMatrix.nRow || this.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix25"));
        }
        if (this.nRow != gMatrix2.nRow || this.nCol != gMatrix2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix26"));
        }
        if (this.nRow == 2 && this.nCol == 2 && this.values[1][0] == 0.0) {
            gMatrix.setIdentity();
            gMatrix3.setIdentity();
            if (this.values[0][1] == 0.0) {
                return 2;
            }
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            double[] dArray5 = new double[]{this.values[0][0], this.values[1][1]};
            GMatrix.compute_2X2(this.values[0][0], this.values[0][1], this.values[1][1], dArray5, dArray, dArray3, dArray2, dArray4, 0);
            GMatrix.update_u(0, gMatrix, dArray3, dArray);
            GMatrix.update_v(0, gMatrix3, dArray4, dArray2);
            return 2;
        }
        return GMatrix.computeSVD(this, gMatrix, gMatrix2, gMatrix3);
    }

    public final int LUD(GMatrix gMatrix, GVector gVector) {
        int n2;
        int n3;
        int n4 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n4];
        int[] nArray = new int[1];
        int[] nArray2 = new int[gMatrix.nRow];
        if (this.nRow != this.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix19"));
        }
        if (this.nRow != gMatrix.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (gMatrix.nRow != gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix20"));
        }
        for (n3 = 0; n3 < this.nRow; ++n3) {
            for (n2 = 0; n2 < this.nCol; ++n2) {
                dArray[n3 * this.nCol + n2] = this.values[n3][n2];
            }
        }
        if (!GMatrix.luDecomposition(gMatrix.nRow, dArray, nArray2, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        for (n3 = 0; n3 < this.nRow; ++n3) {
            for (n2 = 0; n2 < this.nCol; ++n2) {
                gMatrix.values[n3][n2] = dArray[n3 * this.nCol + n2];
            }
        }
        for (n3 = 0; n3 < gMatrix.nRow; ++n3) {
            gVector.values[n3] = nArray2[n3];
        }
        return nArray[0];
    }

    public final void setScale(double d2) {
        int n2;
        int n3 = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (n2 = 0; n2 < this.nRow; ++n2) {
            for (int i2 = 0; i2 < this.nCol; ++i2) {
                this.values[n2][i2] = 0.0;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.values[n2][n2] = d2;
        }
    }

    final void invertGeneral(GMatrix gMatrix) {
        int n2;
        int n3;
        int n4 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        int[] nArray = new int[gMatrix.nRow];
        int[] nArray2 = new int[1];
        if (gMatrix.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix22"));
        }
        for (n3 = 0; n3 < this.nRow; ++n3) {
            for (n2 = 0; n2 < this.nCol; ++n2) {
                dArray[n3 * this.nCol + n2] = gMatrix.values[n3][n2];
            }
        }
        if (!GMatrix.luDecomposition(gMatrix.nRow, dArray, nArray, nArray2)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < this.nCol; ++n3) {
            dArray2[n3 + n3 * this.nCol] = 1.0;
        }
        GMatrix.luBacksubstitution(gMatrix.nRow, dArray, nArray, dArray2);
        for (n3 = 0; n3 < this.nRow; ++n3) {
            for (n2 = 0; n2 < this.nCol; ++n2) {
                this.values[n3][n2] = dArray2[n3 * this.nCol + n2];
            }
        }
    }

    static boolean luDecomposition(int n2, double[] dArray, int[] nArray, int[] nArray2) {
        double d2;
        int n3;
        double d3;
        double[] dArray2 = new double[n2];
        int n4 = 0;
        int n5 = 0;
        nArray2[0] = 1;
        int n6 = n2;
        while (n6-- != 0) {
            d3 = 0.0;
            n3 = n2;
            while (n3-- != 0) {
                d2 = dArray[n4++];
                if (!((d2 = Math.abs(d2)) > d3)) continue;
                d3 = d2;
            }
            if (d3 == 0.0) {
                return false;
            }
            dArray2[n5++] = 1.0 / d3;
        }
        int n7 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n8;
            int n9;
            int n10;
            double d4;
            int n11;
            for (n6 = 0; n6 < n3; ++n6) {
                n11 = n7 + n2 * n6 + n3;
                d4 = dArray[n11];
                n10 = n6;
                n9 = n7 + n2 * n6;
                n8 = n7 + n3;
                while (n10-- != 0) {
                    d4 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += n2;
                }
                dArray[n11] = d4;
            }
            d3 = 0.0;
            int n12 = -1;
            for (n6 = n3; n6 < n2; ++n6) {
                double d5;
                n11 = n7 + n2 * n6 + n3;
                d4 = dArray[n11];
                n10 = n3;
                n9 = n7 + n2 * n6;
                n8 = n7 + n3;
                while (n10-- != 0) {
                    d4 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += n2;
                }
                dArray[n11] = d4;
                d2 = dArray2[n6] * Math.abs(d4);
                if (!(d5 >= d3)) continue;
                d3 = d2;
                n12 = n6;
            }
            if (n12 < 0) {
                throw new RuntimeException(VecMathI18N.getString("GMatrix24"));
            }
            if (n3 != n12) {
                n10 = n2;
                n9 = n7 + n2 * n12;
                n8 = n7 + n2 * n3;
                while (n10-- != 0) {
                    d2 = dArray[n9];
                    dArray[n9++] = dArray[n8];
                    dArray[n8++] = d2;
                }
                dArray2[n12] = dArray2[n3];
                nArray2[0] = -nArray2[0];
            }
            nArray[n3] = n12;
            if (dArray[n7 + n2 * n3 + n3] == 0.0) {
                return false;
            }
            if (n3 == n2 - 1) continue;
            d2 = 1.0 / dArray[n7 + n2 * n3 + n3];
            n11 = n7 + n2 * (n3 + 1) + n3;
            n6 = n2 - 1 - n3;
            while (n6-- != 0) {
                int n13 = n11;
                dArray[n13] = dArray[n13] * d2;
                n11 += n2;
            }
        }
        return true;
    }

    static void luBacksubstitution(int n2, double[] dArray, int[] nArray, double[] dArray2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5;
            int n6;
            int n7 = i2;
            int n8 = -1;
            for (n6 = 0; n6 < n2; ++n6) {
                int n9 = nArray[n3 + n6];
                double d2 = dArray2[n7 + n2 * n9];
                dArray2[n7 + n2 * n9] = dArray2[n7 + n2 * n6];
                if (n8 >= 0) {
                    n5 = n6 * n2;
                    for (n4 = n8; n4 <= n6 - 1; ++n4) {
                        d2 -= dArray[n5 + n4] * dArray2[n7 + n2 * n4];
                    }
                } else if (d2 != 0.0) {
                    n8 = n6;
                }
                dArray2[n7 + n2 * n6] = d2;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                int n10 = n2 - 1 - n6;
                n5 = n2 * n10;
                double d3 = 0.0;
                for (n4 = 1; n4 <= n6; ++n4) {
                    d3 += dArray[n5 + n2 - n4] * dArray2[n7 + n2 * (n2 - n4)];
                }
                dArray2[n7 + n2 * n10] = (dArray2[n7 + n2 * n10] - d3) / dArray[n5 + n10];
            }
        }
    }

    static int computeSVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GMatrix gMatrix4) {
        int n2;
        int n3;
        int n4;
        GMatrix gMatrix5 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix6 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix7 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix8 = new GMatrix(gMatrix);
        if (gMatrix8.nRow >= gMatrix8.nCol) {
            n4 = gMatrix8.nCol;
            n3 = gMatrix8.nCol - 1;
        } else {
            n4 = gMatrix8.nRow;
            n3 = gMatrix8.nRow;
        }
        int n5 = gMatrix8.nRow > gMatrix8.nCol ? gMatrix8.nRow : gMatrix8.nCol;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n3];
        int n6 = 0;
        gMatrix2.setIdentity();
        gMatrix4.setIdentity();
        int n7 = gMatrix8.nRow;
        int n8 = gMatrix8.nCol;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2;
            int n9;
            int n10;
            double d3;
            double d4;
            if (n7 > 1) {
                d4 = 0.0;
                for (n2 = 0; n2 < n7; ++n2) {
                    d4 += gMatrix8.values[n2 + i2][i2] * gMatrix8.values[n2 + i2][i2];
                }
                d4 = Math.sqrt(d4);
                dArray[0] = gMatrix8.values[i2][i2] == 0.0 ? d4 : gMatrix8.values[i2][i2] + GMatrix.d_sign(d4, gMatrix8.values[i2][i2]);
                for (n2 = 1; n2 < n7; ++n2) {
                    dArray[n2] = gMatrix8.values[i2 + n2][i2];
                }
                d3 = 0.0;
                for (n2 = 0; n2 < n7; ++n2) {
                    d3 += dArray[n2] * dArray[n2];
                }
                d3 = 2.0 / d3;
                for (n10 = i2; n10 < gMatrix8.nRow; ++n10) {
                    for (n9 = i2; n9 < gMatrix8.nRow; ++n9) {
                        gMatrix6.values[n10][n9] = -d3 * dArray[n10 - i2] * dArray[n9 - i2];
                    }
                }
                n2 = i2;
                while (n2 < gMatrix8.nRow) {
                    double[] dArray4 = gMatrix6.values[n2];
                    int n11 = n2++;
                    dArray4[n11] = dArray4[n11] + 1.0;
                }
                d2 = 0.0;
                for (n2 = i2; n2 < gMatrix8.nRow; ++n2) {
                    d2 += gMatrix6.values[i2][n2] * gMatrix8.values[n2][i2];
                }
                gMatrix8.values[i2][i2] = d2;
                for (n10 = i2; n10 < gMatrix8.nRow; ++n10) {
                    for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                        gMatrix5.values[n10][n9] = 0.0;
                        for (n2 = i2; n2 < gMatrix8.nCol; ++n2) {
                            double[] dArray5 = gMatrix5.values[n10];
                            int n12 = n9;
                            dArray5[n12] = dArray5[n12] + gMatrix6.values[n10][n2] * gMatrix8.values[n2][n9];
                        }
                    }
                }
                for (n10 = i2; n10 < gMatrix8.nRow; ++n10) {
                    for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                        gMatrix8.values[n10][n9] = gMatrix5.values[n10][n9];
                    }
                }
                for (n10 = i2; n10 < gMatrix8.nRow; ++n10) {
                    for (n9 = 0; n9 < gMatrix8.nCol; ++n9) {
                        gMatrix5.values[n10][n9] = 0.0;
                        for (n2 = i2; n2 < gMatrix8.nCol; ++n2) {
                            double[] dArray6 = gMatrix5.values[n10];
                            int n13 = n9;
                            dArray6[n13] = dArray6[n13] + gMatrix6.values[n10][n2] * gMatrix2.values[n2][n9];
                        }
                    }
                }
                for (n10 = i2; n10 < gMatrix8.nRow; ++n10) {
                    for (n9 = 0; n9 < gMatrix8.nCol; ++n9) {
                        gMatrix2.values[n10][n9] = gMatrix5.values[n10][n9];
                    }
                }
                --n7;
            }
            if (n8 <= 2) continue;
            d4 = 0.0;
            for (n2 = 1; n2 < n8; ++n2) {
                d4 += gMatrix8.values[i2][i2 + n2] * gMatrix8.values[i2][i2 + n2];
            }
            d4 = Math.sqrt(d4);
            dArray[0] = gMatrix8.values[i2][i2 + 1] == 0.0 ? d4 : gMatrix8.values[i2][i2 + 1] + GMatrix.d_sign(d4, gMatrix8.values[i2][i2 + 1]);
            for (n2 = 1; n2 < n8 - 1; ++n2) {
                dArray[n2] = gMatrix8.values[i2][i2 + n2 + 1];
            }
            d3 = 0.0;
            for (n2 = 0; n2 < n8 - 1; ++n2) {
                d3 += dArray[n2] * dArray[n2];
            }
            d3 = 2.0 / d3;
            for (n10 = i2 + 1; n10 < n8; ++n10) {
                for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                    gMatrix7.values[n10][n9] = -d3 * dArray[n10 - i2 - 1] * dArray[n9 - i2 - 1];
                }
            }
            n2 = i2 + 1;
            while (n2 < gMatrix8.nCol) {
                double[] dArray7 = gMatrix7.values[n2];
                int n14 = n2++;
                dArray7[n14] = dArray7[n14] + 1.0;
            }
            d2 = 0.0;
            for (n2 = i2; n2 < gMatrix8.nCol; ++n2) {
                d2 += gMatrix7.values[n2][i2 + 1] * gMatrix8.values[i2][n2];
            }
            gMatrix8.values[i2][i2 + 1] = d2;
            for (n10 = i2 + 1; n10 < gMatrix8.nRow; ++n10) {
                for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                    gMatrix5.values[n10][n9] = 0.0;
                    for (n2 = i2 + 1; n2 < gMatrix8.nCol; ++n2) {
                        double[] dArray8 = gMatrix5.values[n10];
                        int n15 = n9;
                        dArray8[n15] = dArray8[n15] + gMatrix7.values[n2][n9] * gMatrix8.values[n10][n2];
                    }
                }
            }
            for (n10 = i2 + 1; n10 < gMatrix8.nRow; ++n10) {
                for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                    gMatrix8.values[n10][n9] = gMatrix5.values[n10][n9];
                }
            }
            for (n10 = 0; n10 < gMatrix8.nRow; ++n10) {
                for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                    gMatrix5.values[n10][n9] = 0.0;
                    for (n2 = i2 + 1; n2 < gMatrix8.nCol; ++n2) {
                        double[] dArray9 = gMatrix5.values[n10];
                        int n16 = n9;
                        dArray9[n16] = dArray9[n16] + gMatrix7.values[n2][n9] * gMatrix4.values[n10][n2];
                    }
                }
            }
            for (n10 = 0; n10 < gMatrix8.nRow; ++n10) {
                for (n9 = i2 + 1; n9 < gMatrix8.nCol; ++n9) {
                    gMatrix4.values[n10][n9] = gMatrix5.values[n10][n9];
                }
            }
            --n8;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray2[n2] = gMatrix8.values[n2][n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = gMatrix8.values[n2][n2 + 1];
        }
        if (gMatrix8.nRow == 2 && gMatrix8.nCol == 2) {
            double[] dArray10 = new double[1];
            double[] dArray11 = new double[1];
            double[] dArray12 = new double[1];
            double[] dArray13 = new double[1];
            GMatrix.compute_2X2(dArray2[0], dArray3[0], dArray2[1], dArray2, dArray12, dArray10, dArray13, dArray11, 0);
            GMatrix.update_u(0, gMatrix2, dArray10, dArray12);
            GMatrix.update_v(0, gMatrix4, dArray11, dArray13);
            return 2;
        }
        GMatrix.compute_qr(0, dArray3.length - 1, dArray2, dArray3, gMatrix2, gMatrix4);
        n6 = dArray2.length;
        return n6;
    }

    static void compute_qr(int n2, int n3, double[] dArray, double[] dArray2, GMatrix gMatrix, GMatrix gMatrix2) {
        int n4;
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        GMatrix gMatrix3 = new GMatrix(gMatrix.nCol, gMatrix2.nRow);
        double d2 = 1.0;
        double d3 = -1.0;
        boolean bl = false;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < 2 && !bl; ++i2) {
            double d6;
            for (n4 = n2; n4 <= n3; ++n4) {
                if (n4 == n2) {
                    int n5 = dArray2.length == dArray.length ? n3 : n3 + 1;
                    double d7 = GMatrix.compute_shift(dArray[n5 - 1], dArray2[n3], dArray[n5]);
                    d4 = (Math.abs(dArray[n4]) - d7) * (GMatrix.d_sign(d2, dArray[n4]) + d7 / dArray[n4]);
                    d5 = dArray2[n4];
                }
                d6 = GMatrix.compute_rot(d4, d5, dArray6, dArray4);
                if (n4 != n2) {
                    dArray2[n4 - 1] = d6;
                }
                d4 = dArray4[0] * dArray[n4] + dArray6[0] * dArray2[n4];
                dArray2[n4] = dArray4[0] * dArray2[n4] - dArray6[0] * dArray[n4];
                d5 = dArray6[0] * dArray[n4 + 1];
                dArray[n4 + 1] = dArray4[0] * dArray[n4 + 1];
                GMatrix.update_v(n4, gMatrix2, dArray4, dArray6);
                dArray[n4] = d6 = GMatrix.compute_rot(d4, d5, dArray5, dArray3);
                d4 = dArray3[0] * dArray2[n4] + dArray5[0] * dArray[n4 + 1];
                dArray[n4 + 1] = dArray3[0] * dArray[n4 + 1] - dArray5[0] * dArray2[n4];
                if (n4 < n3) {
                    d5 = dArray5[0] * dArray2[n4 + 1];
                    dArray2[n4 + 1] = dArray3[0] * dArray2[n4 + 1];
                }
                GMatrix.update_u(n4, gMatrix, dArray3, dArray5);
            }
            if (dArray.length == dArray2.length) {
                d6 = GMatrix.compute_rot(d4, d5, dArray6, dArray4);
                d4 = dArray4[0] * dArray[n4] + dArray6[0] * dArray2[n4];
                dArray2[n4] = dArray4[0] * dArray2[n4] - dArray6[0] * dArray[n4];
                dArray[n4 + 1] = dArray4[0] * dArray[n4 + 1];
                GMatrix.update_v(n4, gMatrix2, dArray4, dArray6);
            }
            while (n3 - n2 > 1 && Math.abs(dArray2[n3]) < 4.89E-15) {
                --n3;
            }
            for (int i3 = n3 - 2; i3 > n2; --i3) {
                if (!(Math.abs(dArray2[i3]) < 4.89E-15)) continue;
                GMatrix.compute_qr(i3 + 1, n3, dArray, dArray2, gMatrix, gMatrix2);
                n3 = i3 - 1;
                while (n3 - n2 > 1 && Math.abs(dArray2[n3]) < 4.89E-15) {
                    --n3;
                }
            }
            if (n3 - n2 > 1 || !(Math.abs(dArray2[n2 + 1]) < 4.89E-15)) continue;
            bl = true;
        }
        if (Math.abs(dArray2[1]) < 4.89E-15) {
            GMatrix.compute_2X2(dArray[n2], dArray2[n2], dArray[n2 + 1], dArray, dArray5, dArray3, dArray6, dArray4, 0);
            dArray2[n2] = 0.0;
            dArray2[n2 + 1] = 0.0;
        }
        n4 = n2;
        GMatrix.update_u(n4, gMatrix, dArray3, dArray5);
        GMatrix.update_v(n4, gMatrix2, dArray4, dArray6);
    }

    private static void print_se(double[] dArray, double[] dArray2) {
        System.out.println("\ns =" + dArray[0] + " " + dArray[1] + " " + dArray[2]);
        System.out.println("e =" + dArray2[0] + " " + dArray2[1]);
    }

    private static void update_v(int n2, GMatrix gMatrix, double[] dArray, double[] dArray2) {
        for (int i2 = 0; i2 < gMatrix.nRow; ++i2) {
            double d2 = gMatrix.values[i2][n2];
            gMatrix.values[i2][n2] = dArray[0] * d2 + dArray2[0] * gMatrix.values[i2][n2 + 1];
            gMatrix.values[i2][n2 + 1] = -dArray2[0] * d2 + dArray[0] * gMatrix.values[i2][n2 + 1];
        }
    }

    private static void chase_up(double[] dArray, double[] dArray2, int n2, GMatrix gMatrix) {
        int n3;
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GMatrix gMatrix2 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix3 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        double d2 = dArray2[n2];
        double d3 = dArray[n2];
        for (n3 = n2; n3 > 0; --n3) {
            double d4 = GMatrix.compute_rot(d2, d3, dArray4, dArray3);
            d2 = -dArray2[n3 - 1] * dArray4[0];
            d3 = dArray[n3 - 1];
            dArray[n3] = d4;
            dArray2[n3 - 1] = dArray2[n3 - 1] * dArray3[0];
            GMatrix.update_v_split(n3, n2 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
        }
        dArray[n3 + 1] = GMatrix.compute_rot(d2, d3, dArray4, dArray3);
        GMatrix.update_v_split(n3, n2 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
    }

    private static void chase_across(double[] dArray, double[] dArray2, int n2, GMatrix gMatrix) {
        int n3;
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GMatrix gMatrix2 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        GMatrix gMatrix3 = new GMatrix(gMatrix.nRow, gMatrix.nCol);
        double d2 = dArray2[n2];
        double d3 = dArray[n2 + 1];
        for (n3 = n2; n3 < gMatrix.nCol - 2; ++n3) {
            double d4 = GMatrix.compute_rot(d3, d2, dArray4, dArray3);
            d2 = -dArray2[n3 + 1] * dArray4[0];
            d3 = dArray[n3 + 2];
            dArray[n3 + 1] = d4;
            dArray2[n3 + 1] = dArray2[n3 + 1] * dArray3[0];
            GMatrix.update_u_split(n2, n3 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
        }
        dArray[n3 + 1] = GMatrix.compute_rot(d3, d2, dArray4, dArray3);
        GMatrix.update_u_split(n2, n3 + 1, gMatrix, dArray3, dArray4, gMatrix2, gMatrix3);
    }

    private static void update_v_split(int n2, int n3, GMatrix gMatrix, double[] dArray, double[] dArray2, GMatrix gMatrix2, GMatrix gMatrix3) {
        for (int i2 = 0; i2 < gMatrix.nRow; ++i2) {
            double d2 = gMatrix.values[i2][n2];
            gMatrix.values[i2][n2] = dArray[0] * d2 - dArray2[0] * gMatrix.values[i2][n3];
            gMatrix.values[i2][n3] = dArray2[0] * d2 + dArray[0] * gMatrix.values[i2][n3];
        }
        System.out.println("topr    =" + n2);
        System.out.println("bottomr =" + n3);
        System.out.println("cosr =" + dArray[0]);
        System.out.println("sinr =" + dArray2[0]);
        System.out.println("\nm =");
        GMatrix.checkMatrix(gMatrix3);
        System.out.println("\nv =");
        GMatrix.checkMatrix(gMatrix2);
        gMatrix3.mul(gMatrix3, gMatrix2);
        System.out.println("\nt*m =");
        GMatrix.checkMatrix(gMatrix3);
    }

    private static void update_u_split(int n2, int n3, GMatrix gMatrix, double[] dArray, double[] dArray2, GMatrix gMatrix2, GMatrix gMatrix3) {
        for (int i2 = 0; i2 < gMatrix.nCol; ++i2) {
            double d2 = gMatrix.values[n2][i2];
            gMatrix.values[n2][i2] = dArray[0] * d2 - dArray2[0] * gMatrix.values[n3][i2];
            gMatrix.values[n3][i2] = dArray2[0] * d2 + dArray[0] * gMatrix.values[n3][i2];
        }
        System.out.println("\nm=");
        GMatrix.checkMatrix(gMatrix3);
        System.out.println("\nu=");
        GMatrix.checkMatrix(gMatrix2);
        gMatrix3.mul(gMatrix2, gMatrix3);
        System.out.println("\nt*m=");
        GMatrix.checkMatrix(gMatrix3);
    }

    private static void update_u(int n2, GMatrix gMatrix, double[] dArray, double[] dArray2) {
        for (int i2 = 0; i2 < gMatrix.nCol; ++i2) {
            double d2 = gMatrix.values[n2][i2];
            gMatrix.values[n2][i2] = dArray[0] * d2 + dArray2[0] * gMatrix.values[n2 + 1][i2];
            gMatrix.values[n2 + 1][i2] = -dArray2[0] * d2 + dArray[0] * gMatrix.values[n2 + 1][i2];
        }
    }

    private static void print_m(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3) {
        GMatrix gMatrix4 = new GMatrix(gMatrix.nCol, gMatrix.nRow);
        gMatrix4.mul(gMatrix2, gMatrix4);
        gMatrix4.mul(gMatrix4, gMatrix3);
        System.out.println("\n m = \n" + GMatrix.toString(gMatrix4));
    }

    private static String toString(GMatrix gMatrix) {
        StringBuffer stringBuffer = new StringBuffer(gMatrix.nRow * gMatrix.nCol * 8);
        for (int i2 = 0; i2 < gMatrix.nRow; ++i2) {
            for (int i3 = 0; i3 < gMatrix.nCol; ++i3) {
                if (Math.abs(gMatrix.values[i2][i3]) < 1.0E-9) {
                    stringBuffer.append("0.0000 ");
                    continue;
                }
                stringBuffer.append(gMatrix.values[i2][i3]).append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static void print_svd(double[] dArray, double[] dArray2, GMatrix gMatrix, GMatrix gMatrix2) {
        int n2;
        GMatrix gMatrix3 = new GMatrix(gMatrix.nCol, gMatrix2.nRow);
        System.out.println(" \ns = ");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            System.out.println(" " + dArray[n2]);
        }
        System.out.println(" \ne = ");
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            System.out.println(" " + dArray2[n2]);
        }
        System.out.println(" \nu  = \n" + gMatrix.toString());
        System.out.println(" \nv  = \n" + gMatrix2.toString());
        gMatrix3.setIdentity();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            gMatrix3.values[n2][n2] = dArray[n2];
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            gMatrix3.values[n2][n2 + 1] = dArray2[n2];
        }
        System.out.println(" \nm  = \n" + gMatrix3.toString());
        gMatrix3.mulTransposeLeft(gMatrix, gMatrix3);
        gMatrix3.mulTransposeRight(gMatrix3, gMatrix2);
        System.out.println(" \n u.transpose*m*v.transpose  = \n" + gMatrix3.toString());
    }

    static double max(double d2, double d3) {
        if (d2 > d3) {
            return d2;
        }
        return d3;
    }

    static double min(double d2, double d3) {
        if (d2 < d3) {
            return d2;
        }
        return d3;
    }

    static double compute_shift(double d2, double d3, double d4) {
        double d5;
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = Math.abs(d4);
        double d9 = GMatrix.min(d6, d8);
        double d10 = GMatrix.max(d6, d8);
        if (d9 == 0.0) {
            d5 = 0.0;
            if (d10 != 0.0) {
                double d11 = GMatrix.min(d10, d7) / GMatrix.max(d10, d7);
            }
        } else if (d7 < d10) {
            double d12 = d9 / d10 + 1.0;
            double d13 = (d10 - d9) / d10;
            double d14 = d7 / d10;
            double d15 = d14 * d14;
            double d16 = 2.0 / (Math.sqrt(d12 * d12 + d15) + Math.sqrt(d13 * d13 + d15));
            d5 = d9 * d16;
        } else {
            double d17 = d10 / d7;
            if (d17 == 0.0) {
                d5 = d9 * d10 / d7;
            } else {
                double d18 = d9 / d10 + 1.0;
                double d19 = (d10 - d9) / d10;
                double d20 = d18 * d17;
                double d21 = d19 * d17;
                double d22 = 1.0 / (Math.sqrt(d20 * d20 + 1.0) + Math.sqrt(d21 * d21 + 1.0));
                d5 = d9 * d22 * d17;
                d5 += d5;
            }
        }
        return d5;
    }

    static int compute_2X2(double d2, double d3, double d4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n2) {
        double d5;
        double d6;
        double d7 = 2.0;
        double d8 = 1.0;
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d2;
        double d17 = Math.abs(d16);
        double d18 = d4;
        double d19 = Math.abs(d4);
        int n3 = 1;
        boolean bl = d19 > d17;
        if (bl) {
            n3 = 3;
            double d20 = d16;
            d16 = d18;
            d18 = d20;
            d20 = d17;
            d17 = d19;
            d19 = d20;
        }
        if ((d6 = Math.abs(d5 = d3)) == 0.0) {
            dArray[1] = d19;
            dArray[0] = d17;
            d11 = 1.0;
            d12 = 1.0;
            d13 = 0.0;
            d14 = 0.0;
        } else {
            boolean bl2 = true;
            if (d6 > d17) {
                n3 = 2;
                if (d17 / d6 < 1.0E-10) {
                    bl2 = false;
                    d9 = d6;
                    d10 = d19 > 1.0 ? d17 / (d6 / d19) : d17 / d6 * d19;
                    d11 = 1.0;
                    d13 = d18 / d5;
                    d14 = 1.0;
                    d12 = d16 / d5;
                }
            }
            if (bl2) {
                double d21 = d17 - d19;
                double d22 = d21 == d17 ? 1.0 : d21 / d17;
                double d23 = d5 / d16;
                double d24 = 2.0 - d22;
                double d25 = d23 * d23;
                double d26 = d24 * d24;
                double d27 = Math.sqrt(d26 + d25);
                double d28 = d22 == 0.0 ? Math.abs(d23) : Math.sqrt(d22 * d22 + d25);
                double d29 = (d27 + d28) * 0.5;
                if (d6 > d17) {
                    n3 = 2;
                    if (d17 / d6 < 1.0E-10) {
                        bl2 = false;
                        d9 = d6;
                        d10 = d19 > 1.0 ? d17 / (d6 / d19) : d17 / d6 * d19;
                        d11 = 1.0;
                        d13 = d18 / d5;
                        d14 = 1.0;
                        d12 = d16 / d5;
                    }
                }
                if (bl2) {
                    d21 = d17 - d19;
                    d22 = d21 == d17 ? 1.0 : d21 / d17;
                    d23 = d5 / d16;
                    d24 = 2.0 - d22;
                    d25 = d23 * d23;
                    d26 = d24 * d24;
                    d27 = Math.sqrt(d26 + d25);
                    d28 = d22 == 0.0 ? Math.abs(d23) : Math.sqrt(d22 * d22 + d25);
                    d29 = (d27 + d28) * 0.5;
                    d10 = d19 / d29;
                    d9 = d17 * d29;
                    d24 = d25 == 0.0 ? (d22 == 0.0 ? GMatrix.d_sign(d7, d16) * GMatrix.d_sign(d8, d5) : d5 / GMatrix.d_sign(d21, d16) + d23 / d24) : (d23 / (d27 + d24) + d23 / (d28 + d22)) * (d29 + 1.0);
                    d22 = Math.sqrt(d24 * d24 + 4.0);
                    d12 = 2.0 / d22;
                    d14 = d24 / d22;
                    d11 = (d12 + d14 * d23) / d29;
                    d13 = d18 / d16 * d14 / d29;
                }
            }
            if (bl) {
                dArray3[0] = d14;
                dArray2[0] = d12;
                dArray5[0] = d13;
                dArray4[0] = d11;
            } else {
                dArray3[0] = d11;
                dArray2[0] = d13;
                dArray5[0] = d12;
                dArray4[0] = d14;
            }
            if (n3 == 1) {
                d15 = GMatrix.d_sign(d8, dArray5[0]) * GMatrix.d_sign(d8, dArray3[0]) * GMatrix.d_sign(d8, d2);
            }
            if (n3 == 2) {
                d15 = GMatrix.d_sign(d8, dArray4[0]) * GMatrix.d_sign(d8, dArray3[0]) * GMatrix.d_sign(d8, d3);
            }
            if (n3 == 3) {
                d15 = GMatrix.d_sign(d8, dArray4[0]) * GMatrix.d_sign(d8, dArray2[0]) * GMatrix.d_sign(d8, d4);
            }
            dArray[n2] = GMatrix.d_sign(d9, d15);
            double d30 = d15 * GMatrix.d_sign(d8, d2) * GMatrix.d_sign(d8, d4);
            dArray[n2 + 1] = GMatrix.d_sign(d10, d30);
        }
        return 0;
    }

    static double compute_rot(double d2, double d3, double[] dArray, double[] dArray2) {
        double d4;
        double d5;
        double d6;
        if (d3 == 0.0) {
            d6 = 1.0;
            d5 = 0.0;
            d4 = d2;
        } else if (d2 == 0.0) {
            d6 = 0.0;
            d5 = 1.0;
            d4 = d3;
        } else {
            double d7 = d2;
            double d8 = d3;
            double d9 = GMatrix.max(Math.abs(d7), Math.abs(d8));
            if (d9 >= 4.994797680505588E145) {
                int n2 = 0;
                while (d9 >= 4.994797680505588E145) {
                    ++n2;
                    d9 = GMatrix.max(Math.abs(d7 *= 2.002083095183101E-146), Math.abs(d8 *= 2.002083095183101E-146));
                }
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
                int n3 = n2;
                for (int i2 = 1; i2 <= n2; ++i2) {
                    d4 *= 4.994797680505588E145;
                }
            } else if (d9 <= 2.002083095183101E-146) {
                int n4 = 0;
                while (d9 <= 2.002083095183101E-146) {
                    ++n4;
                    d9 = GMatrix.max(Math.abs(d7 *= 4.994797680505588E145), Math.abs(d8 *= 4.994797680505588E145));
                }
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
                int n5 = n4;
                for (int i3 = 1; i3 <= n4; ++i3) {
                    d4 *= 2.002083095183101E-146;
                }
            } else {
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
            }
            if (Math.abs(d2) > Math.abs(d3) && d6 < 0.0) {
                d6 = -d6;
                d5 = -d5;
                d4 = -d4;
            }
        }
        dArray[0] = d5;
        dArray2[0] = d6;
        return d4;
    }

    static double d_sign(double d2, double d3) {
        double d4 = d2 >= 0.0 ? d2 : -d2;
        return d3 >= 0.0 ? d4 : -d4;
    }

    public Object clone() {
        GMatrix gMatrix = null;
        try {
            gMatrix = (GMatrix)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        gMatrix.values = new double[this.nRow][this.nCol];
        for (int i2 = 0; i2 < this.nRow; ++i2) {
            for (int i3 = 0; i3 < this.nCol; ++i3) {
                gMatrix.values[i2][i3] = this.values[i2][i3];
            }
        }
        return gMatrix;
    }
}

